//
//  Adding_Alarms_to_CalendarsAppDelegate.m
//  Adding Alarms to Calendars
//
//  Created by Vandad Nahavandipoor on 24/07/2011.
//  Copyright 2011 Pixolity Ltd. All rights reserved.
//

#import "Adding_Alarms_to_CalendarsAppDelegate.h"

@implementation Adding_Alarms_to_CalendarsAppDelegate

@synthesize window = _window;

- (EKCalendar *)  getFirstModifiableLocalCalendar{
  
  EKCalendar *result = nil;
  
  EKEventStore *eventStore = [[EKEventStore alloc] init];
  
  for (EKCalendar *thisCalendar in eventStore.calendars){
    if (thisCalendar.type == EKCalendarTypeLocal &&
        [thisCalendar allowsContentModifications]){
      return thisCalendar;
    }
  }
  
  return result;
  
}

- (void) addAlarmToCalendar{
  
  EKCalendar *targetCalendar = [self getFirstModifiableLocalCalendar];
  
  if (targetCalendar == nil){
    NSLog(@"Nie znaleziono kalendarza docelowego.");
    return;
  }
  
  EKEventStore *eventStore = [[EKEventStore alloc] init];
  
  /* Wydarzenie rozpoczyna się dokładnie za minutę (60 sekund). */
  NSDate *startDate = [NSDate dateWithTimeIntervalSinceNow:60.0f];
  
  /* Wydarzenie kończy się dokładnie po 20 sekundach. */
  NSDate *endDate = [startDate dateByAddingTimeInterval:20.0f];
  
  EKEvent *eventWithAlarm = [EKEvent eventWithEventStore:eventStore];
  
  eventWithAlarm.calendar = targetCalendar;
  eventWithAlarm.startDate = startDate;
  eventWithAlarm.endDate = endDate;
  
  /* Alarm zostanie wywołany na dwie sekundy przed rozpoczęciem wydarzenia. */
  EKAlarm *alarm = [EKAlarm alarmWithRelativeOffset:-2.0f];
  
  eventWithAlarm.title = @"Wydarzenie wraz z alarmem";
  [eventWithAlarm addAlarm:alarm];
  
  NSError *saveError = nil;
  
  if ([eventStore saveEvent:eventWithAlarm
                       span:EKSpanThisEvent
                      error:&saveError]){
    NSLog(@"Utworzono wydarzenie, które rozpocznie się za minutę.");
  } else {
    NSLog(@"Nie udało się utworzyć wydarzenia z powodu błędu = %@", saveError);
  }
  
  
}

- (BOOL)            application:(UIApplication *)application
  didFinishLaunchingWithOptions:(NSDictionary *)launchOptions{
  
  [self addAlarmToCalendar];
  
  self.window = [[UIWindow alloc] initWithFrame:
                 [[UIScreen mainScreen] bounds]];
  
  self.window.backgroundColor = [UIColor whiteColor];
  [self.window makeKeyAndVisible];
  return YES;
}

- (void)applicationWillResignActive:(UIApplication *)application
{
  /*
   Ta metoda jest wywoływana, gdy aplikacja przechodzi ze stanu aktywnego do nieaktywnego. Może być wywołana w określonych sytuacjach (na przykład w chwili odbywania rozmowy telefonicznej lub po otrzymaniu wiadomości SMS) bądź kiedy użytkownik kończy działanie aplikacji. Metoda rozpoczyna proces przejścia do stanu pozostania w tle. Tę metodę można wykorzystać do wstrzymania wykonywania bieżących zadań, wyłączenia liczników czasu, zmniejszenia liczby klatek generowanych przez OpenGL ES. W grach ta metoda powinna być użyta do wstrzymania gry (pauza).
   */
}

- (void)applicationDidEnterBackground:(UIApplication *)application
{
  /*
   Tę metodę należy wykorzystać do zwolnienia zasobów współdzielonych, zapisania danych użytkownika, wyzerowania liczników czasu oraz do przechowania takiej ilości informacji o stanie, która pozwoli na przywrócenie aplikacji do stanu bieżącego. Jeżeli aplikacja obsługuje działanie w tle, w chwili kończenia działania należy wywołać tę metodę zamiast applicationWillTerminate:.
   */
}

- (void)applicationWillEnterForeground:(UIApplication *)application
{
  /*
   Ta metoda jest wywoływana podczas przechodzenia aplikacji ze stanu aktywnego do działania w tle. Można więc tutaj wycofać wiele zmian wprowadzonych w chwili przechodzenia do stanu działania w tle.
   */
}

- (void)applicationDidBecomeActive:(UIApplication *)application
{
  /*
   W tej metodzie można wznowić działanie zadań zatrzymanych (lub nieuruchomionych), gdy aplikacja była nieaktywna. Jeżeli aplikacja znajdowała się w trybie działania w tle, w metodzie można przeprowadzić odświeżenie interfejsu użytkownika.
   */
}

- (void)applicationWillTerminate:(UIApplication *)application
{
  /*
   Ta metoda jest wywoływana, gdy działanie aplikacji ma zostać zakończone. Zapoznaj się z opisem metody applicationDidEnterBackground:.
   */
}

@end
